#ifndef __ExpGainMain__
#define __ExpGainMain__

/**
 * @file ExpGainMain.h
 * @brief Main function for the ExpGain vst
 *
 * @date 28/01/2006
 * @author Paul Chana
 * @version 1.0.0 Initial version
 *
 * @note All contents of this source code are copyright 2007 Exp Digital Uk.\n
 * This file forms part of the example projects for the Infinity API.\n
 * You may not redistribute either the source code or the compiled binary.\n
 * The Infinity API is covered by a fair use licence which you should have recieved with this\n
 * file. If you didnt receieve the licence, please contact us via http://www.expdigital.co.uk
 *
 * $Id: ExpGainMain.cpp,v 1.2 2007/03/03 02:59:53 paul Exp $
 */

#include "CExpGain.hpp"
#include <Exceptions/CException.hpp>
#include <Host/CApplication.hpp>

//	===========================================================================

using Exponent::ExpGain::CExpGain;
using Exponent::Host::CApplication;
using Exponent::Exceptions::CException;

//	===========================================================================

extern "C" {

#if defined (__GNUC__) && ((__GNUC__ >= 4) || ((__GNUC__ == 3) && (__GNUC_MINOR__ >= 1)))
	#define VST_EXPORT	__attribute__ ((visibility ("default")))
#else
	#define VST_EXPORT
#endif

/**
 * @fn VST_EXPORT AEffect* VSTPluginMain (audioMasterCallback audioMaster)
 * brief The plugin main function
 * @param audioMaster The host callback
 * @retval AEffect* Pointer to the audio effect
 */
VST_EXPORT AEffect* VSTPluginMain (audioMasterCallback audioMaster)
{
	try
	{
		/*
		 * Setup the mac application information
		 * Make sure you call this with your plugins information!
		 */
#ifndef WIN32
		START_EXPONENT_API("Exponent", "ExpGain", "Example VST plugin", "1.0.0", "com.exponent.expgain", "Copyright Exponent Digital 2006, all rights reserved");
#endif
		// Check that the VST version matches
		if (!audioMaster (0, audioMasterVersion, 0, 0, 0, 0))
		{
			return 0;
		}

		// Create a new ExpGain
		AudioEffect *effect = new CExpGain(audioMaster);

		// Check that we have a valid effect
		if (!effect)
		{
			return 0;
		}

		// Return the audio effect
		return effect->getAeffect ();
	}
	catch(CException theException)
	{
		CDialog::notifyUser("Caught exception in main function of ExpGain. Cannot continue to load", "Exception occurred", true);
	}
	catch(...)
	{
		CDialog::notifyUser("Caught exception in main function of ExpGain. Cannot continue to load", "Exception occurred", true);
	}
	return 0;
}

/**
 * cond 
 */
#if (TARGET_API_MAC_CARBON && __ppc__)
#define main main_macho
VST_EXPORT AEffect* main_macho(audioMasterCallback audioMaster) { return VSTPluginMain (audioMaster); }
#elif WIN32
VST_EXPORT AEffect* main(audioMasterCallback audioMaster) { return VSTPluginMain (audioMaster); }
#endif
/**
 * endcond
 */

}	// Extern 'c'


//	===========================================================================

	#if WIN32
		#include <windows.h>
		BOOL WINAPI DllMain (HINSTANCE hInstance, DWORD dwReason, LPVOID lpvReserved)
		{
			/*
			 * These calls below are called to start up and stop the VST plugin GUI.
			 */
			if (dwReason == DLL_PROCESS_ATTACH)
			{
			    /*
				 * Make sure you call this with your plugins information!
				 */
				START_EXPONENT_API(hInstance, "Exponent", "ExpGain", "Example VST plugin", "1.0.0", "Software\\Exponent\\ExpGain", "Copyright Exponent Digital 2006, all rights reserved");
			}
			else if (dwReason == DLL_PROCESS_DETACH)
			{
				/*
				 * Make sure you call this to release all the static variables 
				 */
				 STOP_EXPONENT_API_NO_LOG;
			}
			return 1;
		}
	#endif	// WIN32
#endif	// CExpGain